#include <bits/stdc++.h>

#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")

#define ll long long

using namespace std;

struct point {
    ll x, y;

    point operator+ (point a) { return {x+a.x,y+a.y}; }
    point operator- (point a) { return {x-a.x,y-a.y}; }
};

bool by_c(point a, point b) {
    return a.y != b.y ? (a.y < b.y) : (a.x < b.x);
}

ll cross(point a, point b) {
    return a.x*b.y - a.y*b.x;
}

bool clockw(point a, point b, point c) {
    return cross(a-b,c-b) >= 0;
}

bool by_o(point a, point b) {
    return clockw(a, {0,0}, b);
}

void convex_hull(vector<point> &p) {
    sort(p.begin(), p.end(), by_c);
    point o = p[0];
    for(auto& i : p) i = i - o;
    sort(p.begin()+1, p.end(), by_o);
    vector<point> st;
    for(auto& i : p) {
        while(st.size() > 1 && clockw(st[st.size()-2], st.back(), i))
            st.pop_back();
        st.push_back(i);
    }
    for(auto& i : st) i = i + o;
    p = st;
}

ll area(vector<point>& p) {
    ll a = 0;
    for(int i=0;i<p.size();i++)
        a += (p[i].x*p[(i+1)%p.size()].y-p[(i+1)%p.size()].x*p[i].y)/2;
    if(a<0)
        a = -a;
    return a;
}

int main() {
    ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    int n; cin >> n;
    vector<point> xy(n);
    for(auto& i : xy) cin >> i.x >> i.y;
    vector<point> ch(xy);
    convex_hull(ch);
    if(ch.size() == n) {
        vector<point> t(3);
        ll a;
        for(int i=0;i<n;i++) {
            t[0] = ch[i];
            t[1] = ch[(i+1)%n];
            t[2] = ch[(i+2)%n];
            a = max(a, area(t));
        }
        cout << (area(ch) - a) << endl;
    }
    else {
        vector<point> b(n-1);
        ll mn = LONG_LONG_MAX;
        for(int i=0;i<n;i++) {
            b = vector<point>(n-1);
            for(int j=0;j<n;j++) {
                if(j < i)
                    b[j] = xy[j];
                else if(j > i)
                    b[j-1] = xy[j];
            }
            convex_hull(b);
            mn = min(mn, area(b));
        }
        cout << mn << endl;
    }
    return 0;
}